unit Main;

{--------------------------------------------------------------------
  OLE XLSFile 4.0 Demo Application
  SM Software, 2007
--------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, olexlsf_TLB, ExtCtrls;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet4: TTabSheet;
    Label2: TLabel;
    edFile: TEdit;
    Button2: TButton;
    Button1: TButton;
    Button3: TButton;
    Memo4: TMemo;
    Button6: TButton;
    SpeedDemoTime: TLabel;
    SaveDialog1: TSaveDialog;
    Bevel1: TBevel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    procedure FeaturesDemo;
    procedure SpeedDemo;
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

uses ShellAPI;

procedure OpenFile(AFile: string);
begin
  ShellExecute(0, 'open', PChar(AFile), nil, nil, SW_SHOW);
end;


procedure TForm1.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
    edFile.Text:= SaveDialog1.FileName;
end;

procedure TForm1.FeaturesDemo;
var
  XF: XLSFileObject;
  C: ICells;
  R: IRange;
  S: ISheet;
  W: IWorkbook;
begin
  XF:= CoXLSFileObject.Create;
  W:= XF.XLSFile.Workbook;
  S:= W.Sheets.Item[1];
  S.Name:= 'OLE XLSFile Features Demo';
  S.Columns[1].WidthPx:= 250;
  S.Columns[2].WidthPx:= 100;

  C:= S.Cells;

  C.Cell(1,1).Value:= 'Description';
  C.Cell(1,1).FontHeight:= 14;
  C.Cell(1,1).FontBold:= true;
  C.Cell(1,1).FontColorIndex:= xlColorDarkblue;

  C.Cell(1,2).Value:= 'Sample';
  C.Cell(1,2).FontHeight:= 14;
  C.Cell(1,2).FontBold:= true;
  C.Cell(1,2).FontColorIndex:= xlColorDarkblue;

  S.Rows[2].HeightPx:= 6;

  C.Cell(3,1).Value:= 'Colors and fill pattern';
  C.Cell(3,2).Value:= 'Text';
  C.Cell(3,2).FillPattern:= xlPatternGray8;
  C.Cell(3,2).FillPatternBGColorIndex:= xlColorRed;
  C.Cell(3,2).FillPatternFGColorIndex:= xlColorWhite;

  S.Rows[4].HeightPx:= 6;

  C.Cell(5,1).Value:= 'Rotated text';
  C.Cell(5,2).Value:= 'Text';
  C.Cell(5,2).Rotation:= xlRotation45Up;

  S.Rows[6].HeightPx:= 6;

  C.Cell(7,1).Value:= 'Borders';
  C.Cell(7,2).Value:= 'Text';
  C.Cell(7,2).BorderStyle[xlBorderLeft]:= bsThick ;
  C.Cell(7,2).BorderColorIndex[xlBorderLeft]:= xlColorRed;
  C.Cell(7,2).BorderStyle[xlBorderRight]:= bsThick ;
  C.Cell(7,2).BorderColorIndex[xlBorderRight]:= xlColorYellow;
  C.Cell(7,2).BorderStyle[xlBorderTop]:= bsThick ;
  C.Cell(7,2).BorderColorIndex[xlBorderTop]:= xlColorGreen;
  C.Cell(7,2).BorderStyle[xlBorderBottom]:= bsThick ;
  C.Cell(7,2).BorderColorIndex[xlBorderBottom]:= xlColorBlack;

  S.Rows[8].HeightPx:= 6;

  C.Cell(9,1).Value:= 'Merged cells';
  R:= S.Ranges.Add;
  R.Rects.AddRect(9, 9, 2, 4);
  R.MergeCells;
  R.Value:= 'Merged';
  R.BordersOutline(xlColorBlack, bsThin);

  S.Rows[10].HeightPx:= 6;

  C.Cell(11,1).Value:= 'Formula SIN(1+SIN(1))';
  C.Cell(11,2).Formula:= 'SIN(1+SIN(1))';

  S.Rows[12].HeightPx:= 6;

  C.Cell(13,1).Value:= 'Formatted float value 1.2345';
  C.Cell(13,2).Value:= 1.2345;
  C.Cell(13,2).FormatStringIndex:= 2;

  XF.XLSFile.SaveAs(edFile.text);

  if CheckBox1.Checked then
    OpenFile(edFile.text);
end;


procedure TForm1.SpeedDemo;
var
  I: Integer;
  XF: XLSFileObject;
  C: ICells;
begin
  XF:= CoXLSFileObject.Create;
  C:= XF.XLSFile.Workbook.Sheets[1].Cells;
  for I:= 1 to 10000 do
    C.Cell(I, 1).Value:= 'text' + IntToStr(I);
  XF.XLSFile.SaveAs(edFile.text);

  if CheckBox1.Checked then
    OpenFile(edFile.text);
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  FeaturesDemo;
end;

procedure TForm1.Button6Click(Sender: TObject);
var
  D: TDateTime;
  T: longword;
begin
  D:= Now;
  SpeedDemo;
  T:= round((Now - D) * SecsPerDay);
  SpeedDemoTime.Caption:= 'Test time : ' + IntToStr(T) + ' sec';
end;

end.

